
#ifndef SST_SEP_ATP_MM_H
#define SST_SEP_ATP_MM_H

#include "SST_SEP_TST.h"
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

/*Data operations test struct*/
typedef struct TST_ATP_MMDataOpTestDataStruct{	
    DxByte_t                    TST_Data[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxUint32_t                  TST_DataSize;
    DxByte_t                    TST_OutputData[TST_MAX_DATA_VEC_SIZE_IN_BYTES];
    DxByte_t                    TST_AesKey[TST_AES_KEY_SIZE];
    DxByte_t                    TST_ChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_ChallengeBuffSize;  
    DxByte_t                    TST_EncChallengeBuff[TST_CHALLENGE_SIZE_BYTES];
    DxUint32_t                  TST_EncChallengeBuffSize;
    SSTHandle_t                 TST_PrivAuthHandle;
    SSTHandle_t                 TST_DataHandle;
    SSTHandle_t                 TST_CleanAuthHandle;
    SSTHandle_t                 TST_AESAuthHandle;

} TST_ATP_MMDataOpTestDataStruct;




/*****************************************************************************
* Function Name:                                                           
*  SEPQA_SST_MM_1
*
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
*    Test the mode management set and get APIs and authenticator with mode
*
* Algorithm:
*   // 1. USER - Board: cold boot, PC: exit the ATP application.
*   // 2. USER - Start the ATP application and choose the mode management 0peration test.
*  //  3. Call SST_Terminate and SST_Init.



*    4. Call SST_MMGet and verify the SST is in privilege mode.
*    5. Call SST_SessionCreate.
*    6. Call SST_TransactionStart. 
*    7. Call SST_MMPrivAuthCreate to Create a privileged mode authenticator
*    8. Call SST_AuthenticatorAESSharedSecretCreate.
*    9. Call SST_AuthenticatorPasswordCreate - this Authenticator will be in user mode  - cleaner-authenticator.
*    10. Call SST_MMAuthSet and set to Privileged.
*    11. Call SST_DataInsert with the priv-authenticator as initial control authenticator.
*    12. Call SST_TransactionEnd.
*    13. Call SST_MMPriAuthOpen to open the priv-authenticator on the session.
*    14. Call SST_TransactionStart 
*    15 . Call SST_AuthenticatorBind with the data and aes-authenticator.
*    16. Call SST_AuthenticatorBind with the data and cleaner-authenticator.
*    17. Call SST_DataRead and verify the data is correct. 
*    18. Call SST_AuthenticationClose (priv).
*    19. Call SST_DataRead  FAIL
*    20. Call SST_TransactionEnd.
*    21. Call SST_MMSet and set the system to user mode.
*    22. Call SST_MMPrivAuthOpen to the priv-authenticator, verify the operation failed.
*    23. Call SST_AuthenticatorChallengeGet
*    24. Call CRYS_AES and Encrypt the data with the key fro the AES authenticator
*    25. Call SST_AuthenticationOpen to the aes-authenticator, verify the operation failed.
*    26. Call SST_SessionDelete.



*    27. Call SST_Terminate.
*    28. Call SST_Init
*    29.    #ifndef DX_CC5_SEP_PLAT
*         Call SST_MMSet with user mode
*        #endif // PC
*    30. Call SST_MMGet and verify the SST is in user mode.
*    31. Call SST_SessionCreate.
*    32. Call SST_AuthenticationOpen to the cleaner-authenticator.
*    33. Call SST_TransactionStart 
*    34. Call SST_DataDelete to delete the data object.
*    35. Close the cleaner authenticator.
*    35  Call SST_AuthenticatorDelete to all the authenticators
*    36. Call SST_SessionDelete
*    37. Call SST_TransactionEnd
*******************************************************************************/     
DxError_t SEPQA_SST_MM_1 ( void );
/*****************************************************************************
* Function Name:                                                           
*  SEPQA_SST_MM_2
*
* Inputs:
*  None
*
* Outputs:
*  DxError_t - Function error return
*
* Description:
*    Test the mode management set and get APIs and authenticator with mode
*
* Algorithm:
*    1. USER - Board: cold boot, PC: exit the ATP application.
*    2. USER - Start the ATP application and choose the mode management 0peration test.
*    3. Call SST_Terminate and SST_Init.
*    4. Call SST_MMGet and verify the SST is in privilege mode.
*    5. Call SST_SessionCreate.
*    6. Call SST_TransactionStart. 
*    7. Call SST_MMPrivAuthCreate to Create a privileged mode authenticator
*    8. Call SST_AuthenticatorAESSharedSecretCreate.
*    9. Call SST_AuthenticatorPasswordCreate - this Authenticator will be in user mode  - cleaner-authenticator.
*    10. Call SST_MMAuthSet and set to Privileged.
*    11. Call SST_DataInsert with the priv-authenticator as initial control authenticator.
*    12. Call SST_TransactionEnd.
*    13. Call SST_MMPriAuthOpen to open the priv-authenticator on the session.
*    14. Call SST_TransactionStart 
*    15 . Call SST_AuthenticatorBind with the data and aes-authenticator.
*    16. Call SST_AuthenticatorBind with the data and cleaner-authenticator.
*    17. Call SST_DataRead and verify the data is correct. 
*    18. Call SST_AuthenticationClose (priv).
*    19. Call SST_DataRead  FAIL
*    20. Call SST_TransactionEnd.
*    21. Call SST_MMSet and set the system to user mode.
*    22. Call SST_MMPrivAuthOpen to the priv-authenticator, verify the operation failed.
*    23. Call SST_AuthenticatorChallengeGet
*    24. Call CRYS_AES and Encrypt the data with the key fro the AES authenticator
*    25. Call SST_AuthenticationOpen to the aes-authenticator, verify the operation failed.
*    26. Call SST_SessionDelete.
*    27. Call SST_Terminate.
*    28. Call SST_Init
*    29.    #ifndef DX_CC5_SEP_PLAT
*         Call SST_MMSet with user mode
*        #endif // PC
*    30. Call SST_MMGet and verify the SST is in user mode.
*    31. Call SST_SessionCreate.
*    32. Call SST_AuthenticationOpen to the cleaner-authenticator.
*    33. Call SST_TransactionStart 
*    34. Call SST_DataDelete to delete the data object.
*    35. Close the cleaner authenticator.
*    35  Call SST_AuthenticatorDelete to all the authenticators
*    36. Call SST_SessionDelete
*    37. Call SST_TransactionEnd
*******************************************************************************/     
DxError_t SEPQA_SST_MM_2 ( void );


#ifdef __cplusplus
}


#endif

#endif
